//
//  GHActivityType.h
//  Garmin Health
//
//  Created by Timar, Mihai on 27/12/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//


/**
 *  Activity Types.
 */
typedef NS_ENUM(uint32_t, GHActivityType) {
    
    /** Generic Activity */
    GHActivityTypeGeneric = 0,
    
    /** Running Activity */
    GHActivityTypeRunning = 1,
    
    /** Cycling Activity */
    GHActivityTypeCycling = 2,
    
    /** Transition Activity */
    GHActivityTypeTransition = 3,
    
    /** Fitness Equipment Activity */
    GHActivityTypeFitnessEquipment = 4,
    
    /** Swimming Activity */
    GHActivityTypeSwimming = 5,
    
    /** Walking Activity */
    GHActivityTypeWalking = 6,
    
    /** Sleep Activity */
    GHActivityTypeSleep = 7,
    
    /** Sedentary Activity */
    GHActivityTypeSedentary = 8,
    
    /** Unmonitored Activity */
    GHActivityTypeUnmonitored = 9,
    
    /** Driving Activity */
    GHActivityTypeDriving = 10
};
